function k=findK(n,f)

%
% k=findK(n,f)
%
% Dongrui WU (dongruiw@usc.edu) 4/25/2009
%
% function to find the value K in tolerance limit test according to n
% (number of inputs) and f (confidence). Percentage = 99%
%
% Dongrui WU(dongruiw@usc.edu), Dec 27, 2007

% 90% Confidence     95% Confidence    99% Confidence
%  95% 99% 99.9%      95% 99% 99.9%     95% 99% 99.9%
Table=[2 18.800 24.167 30.227 37.674 48.430 60.573 188.491 242.300 303.054
    3 6.919 8.974 11.309 9.916 12.861 16.208 22.401 29.055 36.616
    4 4.943 6.440 8.149 6.370 8.299 10.502 11.150 14.527 18.383
    5 4.152 5.423 6.879 5.079 6.634 8.415 7.855 10.260 13.015
    6 3.723 4.870 6.188 4.414 5.775 7.337 6.345 8.301 10.548
    7 3.452 4.521 5.750 4.007 5.248 6.676 5.488 7.187 9.142
    8 3.264 4.278 5.446 3.732 4.891 6.226 4.936 6.468 8.234
    9 3.125 4.098 5.220 3.532 4.631 5.899 4.550 5.966 7.600
    10 3.018 3.959 5.046 3.379 4.433 5.649 4.265 5.594 7.129
    15 2.713 3.562 4.545 2.954 3.878 4.949 3.507 4.605 5.876
    20 2.564 3.368 4.300 2.752 3.615 4.614 3.168 4.161 5.312
    25 2.474 3.251 4.151 2.631 3.457 4.413 2.972 3.904 4.985
    30 2.413 3.170 4.049 2.549 3.350 4.278 2.841 3.733 4.768
    35 2.368 3.112 3.974 2.490 3.272 4.179 2.748 3.611 4.611
    40 2.334 3.066 3.917 2.445 3.213 4.104 2.677 3.518 4.493
    45 2.306 3.030 3.871 2.408 3.165 4.042 2.621 3.444 4.399
    50 2.284 3.001 3.833 2.379 3.126 3.993 2.576 3.385 4.323
    55 2.265 2.976 3.801 2.354 3.094 3.951 2.538 3.335 4.260
    60 2.248 2.955 3.774 2.333 3.066 3.916 2.506 3.293 4.206
    65 2.235 2.937 3.751 2.315 3.042 3.886 2.478 3.257 4.160
    70 2.222 2.920 3.730 2.299 3.021 3.859 2.454 3.225 4.120
    75 2.211 2.906 3.712 2.285 3.002 3.853 2.433 3.197 4.084
    80 2.202 2.894 3.696 2.272 2.986 3.814 2.414 3.173 4.053
    85 2.193 2.882 3.682 2.261 2.971 3.795 2.397 3.150 4.024
    90 2.185 2.872 3.669 2.251 2.958 3.778 2.382 3.130 3.999
    95 2.178 2.863 3.657 2.241 2.945 3.763 2.368 3.112 3.976
    100 2.172 2.854 3.646 2.233 2.934 3.748 2.355 3.096 3.954
    110 2.160 2.839 3.626 2.218 2.915 3.723 2.333 3.066 3.917
    120 2.150 2.826 3.610 2.205 2.898 3.702 2.314 3.041 3.885
    130 2.141 2.814 3.595 2.194 2.883 3.683 2.298 3.019 3.857
    140 2.134 2.804 3.582 2.184 2.870 3.666 2.283 3.000 3.833
    150 2.127 2.795 3.571 2.175 2.859 3.652 2.270 2.983 3.811
    160 2.121 2.787 3.561 2.167 2.848 3.638 2.259 2.968 3.792
    170 2.116 2.780 3.552 2.160 2.839 3.527 2.248 2.955 3.774
    180 2.111 2.774 3.543 2.154 2.831 3.616 2.239 2.942 3.759
    190 2.106 2.768 3.536 2.148 2.823 3.606 2.230 2.931 3.744
    200 2.102 2.762 3.529 2.143 2.816 3.597 2.222 2.921 3.731
    250 2.085 2.740 3.501 2.121 2.788 3.561 2.191 2.880 3.678
    300 2.073 2.725 3.481 2.106 2.767 3.535 2.169 2.850 3.641
    400 2.057 2.703 3.453 2.084 2.739 3.499 2.138 2.809 3.589
    500 2.046 2.689 3.434 2.070 2.721 3.475 2.117 2.783 3.555
    600 2.038 2.678 3.421 2.060 2.707 3.458 2.102 2.763 3.530
    700 2.032 2.670 3.411 2.052 2.697 3.445 2.091 2.748 3.511
    800 2.027 2.663 3.402 2.046 2.688 3.434 2.082 2.736 3.495
    900 2.023 2.658 3.396 2.040 2.682 3.426 2.075 2.726 3.483
    1000 2.019 2.654 3.390 2.036 2.676 3.418 2.068 2.718 3.472];

lower=find(Table(:,1)<=n,1,'last');
upper=find(Table(:,1)>=n,1,'first'); %% lower <= n <= upper
if lower==upper
    if f==.95
        k=Table(lower,5);
    elseif f==.99
        k=Table(lower,9);
    end
else %% linear interpolation
    if f==.95
        lowerK=Table(lower,5);
        upperK=Table(upper,5);
        k=(lowerK*(Table(upper,1)-n)+upperK*(n-Table(lower,1)))/(Table(upper,1)-Table(lower,1));
    elseif f==.99
        lowerK=Table(lower,9);
        upperK=Table(upper,9);
        k=(lowerK*(Table(upper,1)-n)+upperK*(n-Table(lower,1)))/(Table(upper,1)-Table(lower,1));
    end
end
